/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.bindings.event.PlayerEvents;
import dev.latvian.mods.kubejs.player.ChestEventJS;
import dev.latvian.mods.kubejs.player.InventoryEventJS;
import dev.latvian.mods.kubejs.player.PlayerAdvancementEventJS;
import dev.latvian.mods.kubejs.player.PlayerChatDecorateEventJS;
import dev.latvian.mods.kubejs.player.PlayerChatReceivedEventJS;
import dev.latvian.mods.kubejs.player.PlayerRespawnedEventJS;
import dev.latvian.mods.kubejs.player.SimplePlayerEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1712;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class KubeJSPlayerEventHandler {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(KubeJSPlayerEventHandler::loggedIn);
        PlayerEvent.PLAYER_QUIT.register(KubeJSPlayerEventHandler::loggedOut);
        TickEvent.PLAYER_POST.register(KubeJSPlayerEventHandler::tick);
        ChatEvent.DECORATE.register(KubeJSPlayerEventHandler::chatDecorate);
        ChatEvent.RECEIVED.register(KubeJSPlayerEventHandler::chatReceived);
        PlayerEvent.PLAYER_ADVANCEMENT.register(KubeJSPlayerEventHandler::advancement);
        PlayerEvent.OPEN_MENU.register(KubeJSPlayerEventHandler::inventoryOpened);
        PlayerEvent.CLOSE_MENU.register(KubeJSPlayerEventHandler::inventoryClosed);
    }

    public static void loggedIn(class_3222 player) {
        PlayerEvents.LOGGED_IN.post(ScriptType.SERVER, new SimplePlayerEventJS((class_1657)player));
        player.field_7498.method_7596((class_1712)player.kjs$getInventoryChangeListener());
        if (!ConsoleJS.SERVER.errors.isEmpty() && !CommonProperties.get().hideServerScriptErrors) {
            player.method_7353(ConsoleJS.SERVER.errorsComponent("/kubejs errors server"), false);
        }
        player.kjs$getStages().sync();
    }

    public static void respawn(class_3222 oldPlayer, class_3222 newPlayer, boolean keepData) {
        newPlayer.kjs$setRawPersistentData(oldPlayer.kjs$getRawPersistentData());
        newPlayer.field_7498.method_7596((class_1712)newPlayer.kjs$getInventoryChangeListener());
        PlayerEvents.RESPAWNED.post(ScriptType.SERVER, new PlayerRespawnedEventJS(newPlayer, oldPlayer, keepData));
        newPlayer.kjs$getStages().sync();
    }

    public static void loggedOut(class_3222 player) {
        PlayerEvents.LOGGED_OUT.post(ScriptType.SERVER, new SimplePlayerEventJS((class_1657)player));
    }

    public static void tick(class_1657 player) {
        if (PlayerEvents.TICK.hasListeners()) {
            PlayerEvents.TICK.post((ScriptTypeHolder)player, new SimplePlayerEventJS(player));
        }
    }

    public static void chatDecorate(class_3222 player, ChatEvent.ChatComponent component) {
        PlayerEvents.DECORATE_CHAT.post(ScriptType.SERVER, new PlayerChatDecorateEventJS(player, component));
    }

    public static EventResult chatReceived(class_3222 player, class_2561 component) {
        return PlayerEvents.CHAT.hasListeners() ? PlayerEvents.CHAT.post(ScriptType.SERVER, new PlayerChatReceivedEventJS(player, component)).arch() : EventResult.pass();
    }

    public static void advancement(class_3222 player, class_161 advancement) {
        if (PlayerEvents.ADVANCEMENT.hasListeners()) {
            PlayerEvents.ADVANCEMENT.post(new PlayerAdvancementEventJS(player, advancement), advancement.method_688());
        }
    }

    public static void inventoryOpened(class_1657 player, class_1703 menu) {
        if (!(menu instanceof class_1723)) {
            menu.method_7596((class_1712)player.kjs$getInventoryChangeListener());
        }
        if (PlayerEvents.INVENTORY_OPENED.hasListeners()) {
            PlayerEvents.INVENTORY_OPENED.post((ScriptTypeHolder)player, (Object)menu, new InventoryEventJS(player, menu));
        }
        if (menu instanceof class_1707 && PlayerEvents.CHEST_OPENED.hasListeners()) {
            PlayerEvents.CHEST_OPENED.post((ScriptTypeHolder)player, (Object)menu, new ChestEventJS(player, menu));
        }
    }

    public static void inventoryClosed(class_1657 player, class_1703 menu) {
        if (PlayerEvents.INVENTORY_CLOSED.hasListeners()) {
            PlayerEvents.INVENTORY_CLOSED.post((ScriptTypeHolder)player, (Object)menu, new InventoryEventJS(player, menu));
        }
        if (menu instanceof class_1707 && PlayerEvents.CHEST_CLOSED.hasListeners()) {
            PlayerEvents.CHEST_CLOSED.post((ScriptTypeHolder)player, (Object)menu, new ChestEventJS(player, menu));
        }
    }
}

